/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: vectors.c$
* $Version : 3.7.4.0$
* $Date    : Jun-19-2012$
*
* Comments:
*
*    This file contains the boot code and exception vector table.
*
*END************************************************************************/


#include "mqx_inc.h"




extern unsigned long     __BOOT_STACK_ADDRESS[];

/* CFM init */
#define CFMNVPROT 0xFF
#define CFMNVOPT  0x00

#ifdef __ICCCF__
    #define BOOT_START __program_start
    
    extern void __program_start(void);
    
    #pragma diag_suppress=Pe177
    #pragma segment="CFMCONFIG"

    const unsigned long _cfm[16] @ "CFMCONFIG" =
#else
    #define BOOT_START __boot
    
    extern void __boot(void);
  
//#pragma define_section cfmconfig ".cfmconfig"  far_absolute RW
//#pragma explicit_zero_data on

//    __declspec(cfmconfig)  unsigned char _cfm[16] = {
#endif  
//    0,0,0,0,0,0,0,0, /* NVBACKKEY */
//    0,0,0,0,0,
//    CFMNVPROT,
//    0,
//    CFMNVOPT
//};



typedef void (*vector_entry)(void);

extern vector_entry __VECTOR_TABLE_ROM_START[]; /* defined in linker command file */
extern vector_entry __VECTOR_TABLE_RAM_START[]; /* defined in linker command file */
extern __declspec(register_abi) asm void asm_rom_handler(void);




#if MQX_ROM_VECTORS

#define DEFAULT_VECTOR  _int_kernel_isr


#ifdef BSP_PSP_CORE_BUILD // See define in build settings menu

extern __declspec(register_abi) asm int asm_idle(void);
extern __declspec(register_abi) asm void asm_interrupts_disable(void);
extern __declspec(register_abi) asm void asm_interrupts_restore(int mask);
extern __declspec(register_abi) asm void asm_exception_handler(void);
extern __declspec(register_abi) asm void asm_exception_handler_func_end(unsigned int vector);
extern __declspec(register_abi) asm void asm_trap_handler(void);
extern __declspec(register_abi) asm void asm_user_trap_handler(void);
extern __declspec(register_abi) asm void asm_user_trap_handler_func_end(void);
extern __declspec(register_abi) asm void asm_rtos_trap_handler(void);



#define ROM_TRAP_HANDLER      asm_rom_handler
#define TRAP_HANDLER          asm_trap_handler
#define INTERRUPT_DISABLE     asm_interrupts_disable
#define INTERRUPT_RESTORE     asm_interrupts_restore
#define IDLE_HANDLER          asm_idle
#define EXCEPTION_HANDLER_END asm_exception_handler_func_end
#define USER_TRAP_HANDLER_END asm_user_trap_handler_func_end
#define USER_TRAP_HANDLER     asm_user_trap_handler
#define EXCEPTION_HANDLER     asm_exception_handler
#define RTOS_TRAP_HANDLER     asm_rtos_trap_handler

#define INT_NMI_HANDLER       DEFAULT_VECTOR
#define FRAMEERR_NMI_HANDLER  DEFAULT_VECTOR
#define SW7_NMI_HANDLER       DEFAULT_VECTOR

#else


#define ROM_TRAP_HANDLER      asm_rom_handler // Rom services must go through trap 0
#define TRAP_HANDLER          DEFAULT_VECTOR
#define INTERRUPT_DISABLE     DEFAULT_VECTOR
#define INTERRUPT_RESTORE     DEFAULT_VECTOR
#define IDLE_HANDLER          DEFAULT_VECTOR
#define EXCEPTION_HANDLER_END DEFAULT_VECTOR
#define USER_TRAP_HANDLER_END DEFAULT_VECTOR
#define USER_TRAP_HANDLER     DEFAULT_VECTOR
#define EXCEPTION_HANDLER     DEFAULT_VECTOR
#define RTOS_TRAP_HANDLER     DEFAULT_VECTOR


extern interrupt void int_nmi_handler(void);
extern interrupt void frameerr_nmi_handler(void);
extern interrupt void swi7_nmi_handler(void);


#define INT_NMI_HANDLER       int_nmi_handler
#define FRAMEERR_NMI_HANDLER  frameerr_nmi_handler
#define SW7_NMI_HANDLER       swi7_nmi_handler



#endif // BSP_PSP_CORE_BUILD



#else
    extern void __boot_exception(void);

    #define DEFAULT_VECTOR  __boot_exception
    #ifdef __ICCCF__

        #error IAR Embedded Workbench for ColdFire is **NOT** supported! 
    
        //#pragma segment="INTVECRAM"
        //const vector_entry ram_vector[252] @ "INTVECRAM" =

    #else
    
        #error RAM vector table is not supported!
    
        //#pragma define_section vectors_ram ".vectors_ram" far_absolute RW
        // array for excepion vectors in ram + space (6 words) for CW fun (when CW debugger handle exceptions, using(rewrite) VBR+0x408 address
        //__declspec(vectors_ram) vector_entry ram_vector[252 + 6] = 
        
    #endif  
    { (vector_entry)__BOOT_STACK_ADDRESS, BOOT_START };
#endif




        
#ifdef __ICCCF__
    // NOTE: This condition is when using IAR ide.  This is not supported.        
    #error IAR Embedded Workbench for ColdFire is **NOT** supported! 
#else        
        
        
// See fxlc95000.h for interrupt offset definition.

typedef void (* vte_t)(void); // exception handler function type
vte_t vector_0   @INT_OFFSET_INITSP               = (vte_t)__BOOT_STACK_ADDRESS;  /*   0 (0x000) Initial supervisor SP */
vte_t vector_1   @INT_OFFSET_INITPC               = (vte_t)&BOOT_START;     /*   1 (0x004) Initial PC            */
vte_t vector_2   @INT_OFFSET_Vaccerr              = DEFAULT_VECTOR;         /*   2 (0x008) Access Error          */
vte_t vector_3   @INT_OFFSET_Vadderr              = DEFAULT_VECTOR;         /*   3 (0x00C) Address Error         */
        
vte_t vector_4   @INT_OFFSET_Viinstr              = DEFAULT_VECTOR;         /*   4 (0x010) Illegal Instruction   */
vte_t vector_5   @INT_OFFSET_VReserved5           = DEFAULT_VECTOR;         /*   5 (0x014) Reserved              */
vte_t vector_6   @INT_OFFSET_VReserved6           = DEFAULT_VECTOR;         /*   6 (0x018) Reserved              */
vte_t vector_7   @INT_OFFSET_VReserved7           = DEFAULT_VECTOR;         /*   7 (0x01C) Reserved              */
vte_t vector_8   @INT_OFFSET_Vprviol              = DEFAULT_VECTOR;         /*   8 (0x020) Privilege Violation   */
vte_t vector_9   @INT_OFFSET_Vtrace               = DEFAULT_VECTOR;         /*   9 (0x024) Trace                 */
vte_t vector_10  @INT_OFFSET_Vunilaop             = DEFAULT_VECTOR;         /*  10 (0x028) Unimplemented A-Line  */
vte_t vector_11  @INT_OFFSET_Vunilfop             = DEFAULT_VECTOR;         /*  11 (0x02C) Unimplemented F-Line  */
vte_t vector_12  @INT_OFFSET_Vdbgi                = DEFAULT_VECTOR;         /*  12 (0x030) Debug Interrupt       */
vte_t vector_13  @INT_OFFSET_VReserved13          = DEFAULT_VECTOR;         /*  13 (0x034) Reserved              */
vte_t vector_14  @INT_OFFSET_Vferror              = DEFAULT_VECTOR;         /*  14 (0x038) Format Error          */
vte_t vector_15  @INT_OFFSET_VReserved15          = DEFAULT_VECTOR;         /*  15 (0x03C) Unitialized Int       */
#if 0
// .vspace16: 0x20 bytes
vte_t vector_16  @INT_OFFSET_VReserved16          = DEFAULT_VECTOR;         /*  16 (0x040) Reserved              */
vte_t vector_17  @INT_OFFSET_VReserved17          = DEFAULT_VECTOR;         /*  17 (0x044) Reserved              */
vte_t vector_18  @INT_OFFSET_VReserved18          = DEFAULT_VECTOR;         /*  18 (0x048) Reserved              */
vte_t vector_19  @INT_OFFSET_VReserved19          = DEFAULT_VECTOR;         /*  19 (0x04C) Reserved              */
vte_t vector_20  @INT_OFFSET_VReserved20          = DEFAULT_VECTOR;         /*  20 (0x050) Reserved              */
vte_t vector_21  @INT_OFFSET_VReserved21          = DEFAULT_VECTOR;         /*  21 (0x054) Reserved              */
vte_t vector_22  @INT_OFFSET_VReserved22          = DEFAULT_VECTOR;         /*  22 (0x058) Reserved              */
vte_t vector_23  @INT_OFFSET_VReserved23          = DEFAULT_VECTOR;         /*  23 (0x05C) Reserved              */
#endif
vte_t vector_24  @INT_OFFSET_Vspuri               = DEFAULT_VECTOR;         /*  24 (0x060) Spurious Interrupt    */
vte_t vector_25  @INT_OFFSET_VReserved25          = DEFAULT_VECTOR;         /*  25 (0x064) Autovector Level 1    */
#if 0
// .vspace26: 0x18 bytes
vte_t vector_26  @INT_OFFSET_VReserved26          = DEFAULT_VECTOR;         /*  26 (0x068) Reserved              */
vte_t vector_27  @INT_OFFSET_VReserved27          = DEFAULT_VECTOR;         /*  27 (0x06C) Reserved              */
vte_t vector_28  @INT_OFFSET_VReserved28          = DEFAULT_VECTOR;         /*  28 (0x070) Reserved              */
vte_t vector_29  @INT_OFFSET_VReserved29          = DEFAULT_VECTOR;         /*  29 (0x074) Reserved              */
vte_t vector_30  @INT_OFFSET_VReserved30          = DEFAULT_VECTOR;         /*  30 (0x078) Reserved              */
vte_t vector_31  @INT_OFFSET_VReserved31          = DEFAULT_VECTOR;         /*  31 (0x07C) Reserved              */
#endif
vte_t vector_32  @INT_OFFSET_Vtrap0               = ROM_TRAP_HANDLER;          /*  32 (0x080) TRAP #0               */
vte_t vector_33  @INT_OFFSET_Vtrap1               = TRAP_HANDLER;              /*  33 (0x084) TRAP #1               */
vte_t vector_34  @INT_OFFSET_Vtrap2               = INTERRUPT_DISABLE;         /*  34 (0x088) TRAP #2               */
vte_t vector_35  @INT_OFFSET_Vtrap3               = (vte_t)INTERRUPT_RESTORE;  /*  35 (0x08C) TRAP #3               */
vte_t vector_36  @INT_OFFSET_Vtrap4               = (vte_t)IDLE_HANDLER;       /*  36 (0x090) TRAP #4               */
vte_t vector_37  @INT_OFFSET_Vtrap5               = (vte_t)EXCEPTION_HANDLER_END;  /*  37 (0x094) TRAP #5               */
vte_t vector_38  @INT_OFFSET_Vtrap6               = USER_TRAP_HANDLER_END;     /*  38 (0x098) TRAP #6               */
vte_t vector_39  @INT_OFFSET_Vtrap7               = RTOS_TRAP_HANDLER;         /*  39 (0x09C) TRAP #7               */
vte_t vector_40  @INT_OFFSET_Vtrap8               = DEFAULT_VECTOR;         /*  40 (0x0A0) TRAP #8               */
vte_t vector_41  @INT_OFFSET_Vtrap9               = DEFAULT_VECTOR;         /*  41 (0x0A4) TRAP #9               */
vte_t vector_42  @INT_OFFSET_Vtrap10              = DEFAULT_VECTOR;         /*  42 (0x0A8) TRAP #10              */
vte_t vector_43  @INT_OFFSET_Vtrap11              = DEFAULT_VECTOR;         /*  43 (0x0AC) TRAP #11              */
vte_t vector_44  @INT_OFFSET_Vtrap12              = USER_TRAP_HANDLER;      /* [0] */  /*  44 (0x0B0) TRAP #12              */
vte_t vector_45  @INT_OFFSET_Vtrap13              = USER_TRAP_HANDLER;      /* [1] */  /*  45 (0x0B4) TRAP #13              */
vte_t vector_46  @INT_OFFSET_Vtrap14              = USER_TRAP_HANDLER;      /* [2] */  /*  46 (0x0B8) TRAP #14              */
vte_t vector_47  @INT_OFFSET_Vtrap15              = USER_TRAP_HANDLER;      /* [3] */  /*  47 (0x0BC) TRAP #15              */
// This region of unused exception vectors can be commented out and used for firmware if needed
#if 0
// .vspace48: 0x34 bytes
vte_t vector_48  @INT_OFFSET_VReserved48          = DEFAULT_VECTOR;         /*  48 (0x0C0) Reserved              */
vte_t vector_49  @INT_OFFSET_VReserved49          = DEFAULT_VECTOR;         /*  49 (0x0C4) Reserved              */
vte_t vector_50  @INT_OFFSET_VReserved50          = DEFAULT_VECTOR;         /*  50 (0x0C8) Reserved              */
vte_t vector_51  @INT_OFFSET_VReserved51          = DEFAULT_VECTOR;         /*  51 (0x0CC) Reserved              */
vte_t vector_52  @INT_OFFSET_VReserved52          = DEFAULT_VECTOR;         /*  52 (0x0D0) Reserved              */
vte_t vector_53  @INT_OFFSET_VReserved53          = DEFAULT_VECTOR;         /*  53 (0x0D4) Reserved              */
vte_t vector_54  @INT_OFFSET_VReserved54          = DEFAULT_VECTOR;         /*  54 (0x0D8) Reserved              */
vte_t vector_55  @INT_OFFSET_VReserved55          = DEFAULT_VECTOR;         /*  55 (0x0DC) Reserved              */
vte_t vector_56  @INT_OFFSET_VReserved56          = DEFAULT_VECTOR;         /*  56 (0x0E0) Reserved              */
vte_t vector_57  @INT_OFFSET_VReserved57          = DEFAULT_VECTOR;         /*  57 (0x0E4) Reserved              */
vte_t vector_58  @INT_OFFSET_VReserved58          = DEFAULT_VECTOR;         /*  58 (0x0E8) Reserved              */
vte_t vector_59  @INT_OFFSET_VReserved59          = DEFAULT_VECTOR;         /*  59 (0x0EC) Reserved              */
vte_t vector_60  @INT_OFFSET_VReserved60          = DEFAULT_VECTOR;         /*  60 (0x0F0) Reserved              */
#endif
vte_t vector_61  @INT_OFFSET_Vunsinstr            = DEFAULT_VECTOR;         /*  61 (0x0F4) Unsinstr              */
vte_t vector_62  @INT_OFFSET_VReserved62          = DEFAULT_VECTOR;         /*  62 (0x0F8) Reserved              */
vte_t vector_63  @INT_OFFSET_VReserved63          = DEFAULT_VECTOR;         /*  63 (0x0FC) Reserved              */
vte_t vector_64  @INT_OFFSET_Virq                 = INT_NMI_HANDLER;         /*  64 (0x100) Virq                  */
vte_t vector_65  @INT_OFFSET_Vframe_err           = FRAMEERR_NMI_HANDLER;    /*  65 (0x104) Vframe_err            */


#if 0
// .vspace66: 0x10 bytes
vte_t vector_66  @INT_OFFSET_VReserved66          = DEFAULT_VECTOR;         /*  66 (0x108) Reserved              */
vte_t vector_67  @INT_OFFSET_VReserved67          = DEFAULT_VECTOR;         /*  67 (0x10C) Reserved              */
vte_t vector_68  @INT_OFFSET_VReserved68          = DEFAULT_VECTOR;         /*  68 (0x110) Reserved              */
vte_t vector_69  @INT_OFFSET_VReserved69          = DEFAULT_VECTOR;         /*  69 (0x114) Reserved              */
#endif
vte_t vector_70  @INT_OFFSET_Vtpm1ovf             = DEFAULT_VECTOR;         /*  70 (0x118) Vtpm1ovf              */
vte_t vector_71  @INT_OFFSET_Vtpm1ch0             = DEFAULT_VECTOR;         /*  71 (0x11C) Vtpm1ch0              */
vte_t vector_72  @INT_OFFSET_Vtpm1ch1             = DEFAULT_VECTOR;         /*  72 (0x120) Vtpm1ch1              */
vte_t vector_73  @INT_OFFSET_VReserved73          = DEFAULT_VECTOR;         /*  73 (0x124) Reserved              */
vte_t vector_74  @INT_OFFSET_VReserved74          = DEFAULT_VECTOR;         /*  74 (0x128) Reserved              */
vte_t vector_75  @INT_OFFSET_Vmtim                = DEFAULT_VECTOR;         /*  75 (0x12C) Vmtim                 */

// NOTE: PDB is the sytem timer tick.
vte_t vector_76  @INT_OFFSET_Vpdb_a               = DEFAULT_VECTOR;         /*  76 (0x130) Vpdb_a                */
vte_t vector_77  @INT_OFFSET_Vpdb_b               = DEFAULT_VECTOR;         /*  77 (0x134) Vpdb_b                */
#if 0
// .vspace78: 0x10 bytes
vte_t vector_78  @INT_OFFSET_VReserved78          = DEFAULT_VECTOR;         /*  78 (0x138) Reserved              */
vte_t vector_79  @INT_OFFSET_VReserved79          = DEFAULT_VECTOR;         /*  79 (0x13C) Reserved              */
vte_t vector_80  @INT_OFFSET_VReserved80          = DEFAULT_VECTOR;         /*  80 (0x140) Reserved              */
vte_t vector_81  @INT_OFFSET_VReserved81          = DEFAULT_VECTOR;         /*  81 (0x144) Reserved              */
#endif
vte_t vector_82  @INT_OFFSET_Vsp_wake             = DEFAULT_VECTOR;         /*  82 (0x148) Vsp_wake              */
#if 0
// .vspace83: 0x1C bytes
vte_t vector_83  @INT_OFFSET_VReserved83          = DEFAULT_VECTOR;         /*  83 (0x14C) Reserved              */
vte_t vector_84  @INT_OFFSET_VReserved84          = DEFAULT_VECTOR;         /*  84 (0x150) Reserved              */
vte_t vector_85  @INT_OFFSET_VReserved85          = DEFAULT_VECTOR;         /*  85 (0x154) Reserved              */
vte_t vector_86  @INT_OFFSET_VReserved86          = DEFAULT_VECTOR;         /*  86 (0x158) Reserved              */
vte_t vector_87  @INT_OFFSET_VReserved87          = DEFAULT_VECTOR;         /*  87 (0x15C) Reserved              */
vte_t vector_88  @INT_OFFSET_VReserved88          = DEFAULT_VECTOR;         /*  88 (0x160) Reserved              */
vte_t vector_89  @INT_OFFSET_VReserved89          = DEFAULT_VECTOR;         /*  89 (0x164) Reserved              */
#endif
vte_t vector_90  @INT_OFFSET_Vsp_to_0             = DEFAULT_VECTOR;         /*  90 (0x168) Vsp_to_0              */
vte_t vector_91  @INT_OFFSET_Vsp_to_1             = DEFAULT_VECTOR;         /*  91 (0x16C) Vsp_to_1              */
vte_t vector_92  @INT_OFFSET_VReserved92          = DEFAULT_VECTOR;         /*  92 (0x170) Reserved              */
vte_t vector_93  @INT_OFFSET_VReserved93          = DEFAULT_VECTOR;         /*  93 (0x174) Reserved              */
vte_t vector_94  @INT_OFFSET_VReserved94          = DEFAULT_VECTOR;         /*  94 (0x178) Reserved              */
vte_t vector_95  @INT_OFFSET_Vstart_of_frame      = DEFAULT_VECTOR;         /*  95 (0x17C) Vstart_of_frame       */
vte_t vector_96  @INT_OFFSET_VConvComplete        = DEFAULT_VECTOR;         /*  96 (0x180) Vconversion_complete  */
#if 0
// .vspace97: 0x10 bytes
vte_t vector_97  @INT_OFFSET_VReserved97          = DEFAULT_VECTOR;         /*  97 (0x184) Reserved              */
vte_t vector_98  @INT_OFFSET_VReserved98          = DEFAULT_VECTOR;         /*  98 (0x188) Reserved              */
vte_t vector_99  @INT_OFFSET_VReserved99          = DEFAULT_VECTOR;         /*  99 (0x18C) Reserved              */
vte_t vector_100 @INT_OFFSET_VReserved100         = DEFAULT_VECTOR;         /* 100 (0x190) Reserved              */
#endif
vte_t vector_101 @INT_OFFSET_Vmaster_i2c          = DEFAULT_VECTOR;         /* 101 (0x194) Vmaster_i2c           */
vte_t vector_102 @INT_OFFSET_VReserved102         = DEFAULT_VECTOR;         /* 102 (0x198) Reserved              */
vte_t vector_103 @INT_OFFSET_VL7swi               = SW7_NMI_HANDLER;        /* 103 (0x19C) VL7swi                */
vte_t vector_104 @INT_OFFSET_VL6swi               = DEFAULT_VECTOR;         /* 104 (0x1A0) VL6swi                */
vte_t vector_105 @INT_OFFSET_VL5swi               = DEFAULT_VECTOR;         /* 105 (0x1A4) VL5swi                */
vte_t vector_106 @INT_OFFSET_VL4swi               = DEFAULT_VECTOR;         /* 106 (0x1A8) VL4swi                */
vte_t vector_107 @INT_OFFSET_VL3swi               = DEFAULT_VECTOR;         /* 107 (0x1AC) VL3swi                */
vte_t vector_108 @INT_OFFSET_VL2swi               = DEFAULT_VECTOR;         /* 108 (0x1B0) VL2swi                */
vte_t vector_109 @INT_OFFSET_VL1swi               = DEFAULT_VECTOR;         /* 109 (0x1B4) VL1swi                */
#if 0
vte_t vector_110 @INT_OFFSET_VReserved110         = DEFAULT_VECTOR;         /* 110 (0x1B8) Reserved              */
vte_t vector_111 @INT_OFFSET_VReserved111         = DEFAULT_VECTOR;         /* 111 (0x1BC) Reserved              */
vte_t vector_112 @INT_OFFSET_VReserved112         = DEFAULT_VECTOR;         /* 112 (0x1C0) Reserved              */
vte_t vector_113 @INT_OFFSET_VReserved113         = DEFAULT_VECTOR;         /* 113 (0x1C4) Reserved              */
vte_t vector_114 @INT_OFFSET_VReserved114         = DEFAULT_VECTOR;         /* 114 (0x1C8) Reserved              */
#endif
        
#endif // __ICCCF__


